<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<!-- 
####################################################################################
#  XSL name : section1
#  Version : R2.0.9.S01                                        
#  Intermediate release number : 014-20161025                                    
#  Last update : 14/04/2016                                                      
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"  xmlns:ted="http://formex.publications.europa.eu/ted/schema/reception/R2.0.9.S01" exclude-result-prefixes="ted">
	<!---->
	<xsl:template match="ted:DOCUMENT_FULL|ted:DOCUMENT_RESTRICTED|ted:URL_DOCUMENT|ted:ADDRESS_FURTHER_INFO_IDEM|ted:ADDRESS_FURTHER_INFO|ted:URL_PARTICIPATION|ted:ADDRESS_PARTICIPATION|ted:ADDRESS_PARTICIPATION_IDEM|ted:URL_TOOL" mode="R300">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM!='F21' and @FORM!='F22'  and @FORM!='F23']"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@TYPE!='AWARD_CONTRACT' and @TYPE!='CONCESSION_AWARD_CONTRACT']"/>
			<xsl:otherwise>
			<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name(.))"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R300'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		</xsl:template>
	<!---->
	<xsl:template match="ted:DOCUMENT_FULL|ted:DOCUMENT_RESTRICTED|ted:URL_DOCUMENT" mode="R301R302R303">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM!='F01' and @FORM!='F04' and @FORM!='F07']"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@TYPE!='PRI_ONLY' and @TYPE!='PER_ONLY']"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@TYPE='QSU_CALL_COMPETITION']"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name(.))"/>
				<xsl:variable name="ele2" select="local-name(.)"/>
				<xsl:choose>
					<xsl:when test="ancestor::*[@FORM='F01']">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R301'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="ancestor::*[@FORM='F04']">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R302'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="ancestor::*[@FORM='F07']">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R303'"/>
							<xsl:with-param name="content" select="$ele2"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM][ted:NOTICE[@TYPE!='AWARD_CONTRACT' and @TYPE!='CONCESSION_AWARD_CONTRACT']]" mode="R304">
		<xsl:choose>
			<xsl:when test="@FORM!='F21' and @FORM!='F22'  and @FORM!='F23'"/>
			<xsl:when test=".//ted:ADDRESS_FURTHER_INFO_IDEM|.//ted:ADDRESS_FURTHER_INFO"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R304'"/>
					<xsl:with-param name="content" select="concat('NOTICE/@TYPE=',ted:NOTICE/@TYPE,' and ', 'missing ADDRESS_FURTHER_INFO(_IDEM)')"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:URL_PARTICIPATION|ted:ADDRESS_PARTICIPATION|ted:ADDRESS_PARTICIPATION_IDEM" mode="R305R306">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM!='F01' and @FORM!='F04' and @FORM!='F21' and @FORM!='F22']"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@TYPE!='PRI_ONLY' and @TYPE!='PER_ONLY']"/>
			<xsl:otherwise>
					<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name(.))"/>
				<xsl:choose>
					<xsl:when test="ancestor::*[@FORM='F01' or @FORM='F21']">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R305'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="ancestor::*[@FORM='F04' or @FORM='F22']">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R306'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM][ted:NOTICE[@TYPE!='PRI_ONLY' and @TYPE!='PER_ONLY' and @TYPE!='AWARD_CONTRACT' and @TYPE!='CONCESSION_AWARD_CONTRACT']]" mode="R307R308R309R310">
		<xsl:choose>
			<xsl:when test="@FORM!='F01' and @FORM!='F04' and @FORM!='F21' and @FORM!='F22' and @FORM!='F23'"/>
			<xsl:when test=".//ted:URL_PARTICIPATION|.//ted:ADDRESS_PARTICIPATION|.//ted:ADDRESS_PARTICIPATION_IDEM"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('NOTICE/@TYPE=',ted:NOTICE/@TYPE,' and ', 'missing {URL_PARTICIPATION,ADDRESS_PARTICIPATION(_IDEM)}')"/>
				<xsl:choose>
					<xsl:when test=".//@TYPE='PRI_REDUCING_TIME_LIMITS'">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R307'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test=".//@TYPE='PRI_CALL_COMPETITION' or .//@TYPE='PER_CALL_COMPETITION' or .//@TYPE='CONTRACT'">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R308'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test=".//@TYPE='QSU_ONLY' or .//@TYPE='QSU_CALL_COMPETITION'">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R309'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test=".//@TYPE='PRI'">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R310'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>					
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:CA_TYPE|ted:CA_TYPE_OTHER" mode="R311">
		<xsl:choose>
			<xsl:when test="not(ancestor::*[@FORM]//ted:DIRECTIVE) or ancestor::*[@FORM]//ted:DIRECTIVE/@*!='2014/25/EU'"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R311'"/>
					<xsl:with-param name="content" select="concat('DIRECTIVE/@VALUE=',ancestor::*[@FORM]//ted:DIRECTIVE/@*,' and ',local-name(.))"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:CA_ACTIVITY|ted:CA_ACTIVITY_OTHER" mode="R312">
		<xsl:choose>
			<xsl:when test="not(ancestor::*[@FORM]//ted:DIRECTIVE) or ancestor::*[@FORM]//ted:DIRECTIVE/@*!='2014/25/EU'"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R312'"/>
					<xsl:with-param name="content" select="concat('DIRECTIVE/@VALUE=', ancestor::*[@FORM]//ted:DIRECTIVE/@*,' and ',local-name(.))"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:CE_ACTIVITY|ted:CE_ACTIVITY_OTHER" mode="R313">
		<xsl:choose>
			<xsl:when test="not(ancestor::*[@FORM]//ted:DIRECTIVE) or ancestor::*[@FORM]//ted:DIRECTIVE/@*!='2014/24/EU'"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R313'"/>
					<xsl:with-param name="content" select="concat('DIRECTIVE/@VALUE=', ancestor::*[@FORM]//ted:DIRECTIVE/@*,' and ',local-name(.))"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
		<!---->
<!--	<xsl:template match="text()" priority="-1" mode="#all"/>
	<xsl:template match="@*|node()" priority="-2" mode="#all">
		<xsl:apply-templates select="@*|*" mode="#current"/>
	</xsl:template>-->
</xsl:stylesheet>
